<?php
require_once __DIR__ . '/Database.php';

class Branch {
    private $conn;
    private $table = 'branches';

    public function __construct() {
        $database = new Database();
        $this->conn = $database->getConnection();
    }

    public function getAll() {
        $query = "SELECT * FROM " . $this->table . " ORDER BY name ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function create($name, $code, $address) {
        $query = "INSERT INTO " . $this->table . " (name, code, address) VALUES (:name, :code, :address)";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':code', $code);
        $stmt->bindParam(':address', $address);
        return $stmt->execute();
    }
}
