<?php
// templates/layout.php
// Expects $content (path to partial) and $user (auth user) to be defined
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?></title>
    <style>
        /* Shared Styles */
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: #f3f4f6; display: flex; height: 100vh; }
        .sidebar { width: 250px; background: #1f2937; color: white; display: flex; flex-direction: column; flex-shrink: 0; }
        .sidebar-header { padding: 1.5rem; font-size: 1.5rem; font-weight: bold; border-bottom: 1px solid #374151; }
        .nav-links { flex: 1; padding: 1rem 0; overflow-y: auto; }
        .nav-link { display: block; padding: 0.75rem 1.5rem; color: #d1d5db; text-decoration: none; transition: 0.2s; }
        .nav-link:hover, .nav-link.active { background: #374151; color: white; }
        
        .main-content { flex: 1; display: flex; flex-direction: column; overflow: hidden; }
        .topbar { background: white; padding: 1rem 2rem; border-bottom: 1px solid #e5e7eb; display: flex; justify-content: space-between; align-items: center; }
        .user-info { display: flex; align-items: center; gap: 1rem; }
        .logout-btn { color: #ef4444; text-decoration: none; font-size: 0.9rem; }

        .page-content { flex: 1; padding: 2rem; overflow-y: auto; }
        .card { background: white; padding: 1.5rem; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); margin-bottom: 1.5rem; }
        
        /* Table Styles */
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #e5e7eb; }
        th { background: #f9fafb; font-weight: 600; color: #374151; }
        
        /* Form Styles */
        .form-group { margin-bottom: 1rem; }
        .form-control { width: 100%; padding: 0.5rem; border: 1px solid #d1d5db; border-radius: 4px; box-sizing: border-box; }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="sidebar-header">AUP HR</div>
        <nav class="nav-links">
            <a href="index.php?action=dashboard" class="nav-link">Dashboard</a>
            
            <?php if($auth->hasRole('hr_admin') || $auth->hasRole('super_admin')): ?>
                <a href="index.php?action=employees" class="nav-link">Employees</a>
                <a href="index.php?action=branches" class="nav-link">Branches</a>
                <a href="index.php?action=payroll_config" class="nav-link">Payroll Setup</a>
            <?php endif; ?>

            <?php if($auth->hasRole('branch_manager')): ?>
                <a href="index.php?action=my_branch" class="nav-link">My Branch</a>
                <a href="index.php?action=payroll_input" class="nav-link">Payroll Input</a>
            <?php endif; ?>
            
            <?php if($auth->hasRole('employee')): ?>
                 <a href="index.php?action=payslips" class="nav-link">My Payslips</a>
            <?php endif; ?>
             <a href="index.php?action=leave" class="nav-link">Leave Applications</a>
        </nav>
    </div>

    <div class="main-content">
        <div class="topbar">
            <h2><?php echo isset($page_title) ? $page_title : 'Dashboard'; ?></h2>
            <div class="user-info">
                <span><?php echo htmlspecialchars($user['username']); ?></span>
                <a href="index.php?action=logout" class="logout-btn">Logout</a>
            </div>
        </div>

        <div class="page-content">
            <?php 
            if (isset($content) && file_exists($content)) {
                include $content;
            } else {
                echo "<p>Content not found.</p>";
            }
            ?>
        </div>
    </div>
</body>
</html>
