<?php
require_once __DIR__ . '/../src/Payroll.php';
$payroll = new Payroll();
$month = isset($_GET['month']) ? $_GET['month'] : date('n');
$year = isset($_GET['year']) ? $_GET['year'] : date('Y');
$branch_id = $_SESSION['branch_id'];

// Handle Save
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $inputs = [];
    foreach ($_POST['input'] as $eid => $val) {
        $inputs[$eid] = [
            'var' => floatval($val['var']),
            'ded' => floatval($val['ded'])
        ];
    }
    $payroll->saveVariableInput($month, $year, $inputs);
    $success = "Payroll inputs saved for " . date('F', mktime(0, 0, 0, $month, 10));
}

$employees = $payroll->getMonthlyVariables($branch_id, $month, $year);
?>

<div class="card">
    <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
        <h2>Payroll Input (Variable)</h2>
        <form method="GET" action="index.php">
            <input type="hidden" name="action" value="payroll_input">
            <select name="month" style="padding: 8px;">
                <?php for($m=1; $m<=12; $m++): ?>
                    <option value="<?php echo $m; ?>" <?php echo ($m==$month)?'selected':''; ?>>
                        <?php echo date('F', mktime(0, 0, 0, $m, 10)); ?>
                    </option>
                <?php endfor; ?>
            </select>
            <input type="number" name="year" value="<?php echo $year; ?>" style="padding: 8px; width: 80px;">
            <button type="submit" style="padding: 8px;">Go</button>
        </form>
    </div>

    <?php if(isset($success)): ?>
        <div style="background: #dcfce7; color: green; padding: 10px; margin-bottom: 10px;"><?php echo $success; ?></div>
    <?php endif; ?>

    <form method="POST">
        <table>
            <thead>
                <tr>
                    <th>Emp ID</th>
                    <th>Name</th>
                    <th>Basic Salary</th>
                    <th>Variable (Bonus/TA)</th>
                    <th>Deductions (Fine/Loan)</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($employees as $e): ?>
                <tr>
                    <td><?php echo htmlspecialchars($e['emp_code']); ?></td>
                    <td><?php echo htmlspecialchars($e['full_name']); ?></td>
                    <td><?php echo number_format($e['basic_salary'], 2); ?></td>
                    <td>
                        <input type="number" step="0.01" name="input[<?php echo $e['employee_id']; ?>][var]" 
                               value="<?php echo $e['variable_allowance']; ?>" style="width: 100px;">
                    </td>
                    <td>
                        <input type="number" step="0.01" name="input[<?php echo $e['employee_id']; ?>][ded]" 
                               value="<?php echo $e['other_deductions']; ?>" style="width: 100px;">
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <div style="margin-top: 20px; text-align: right;">
            <button type="submit" style="background: #2563eb; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer;">Save Draft</button>
        </div>
    </form>
</div>
