<?php
require_once __DIR__ . '/../src/Payroll.php';
$payroll = new Payroll();
// Logic: If Admin, can view any by ID. If Employee, only own.
$month = date('n'); $year = date('Y');
$sheet = $payroll->getSalarySheet($month, $year);

$my_slip = null;
foreach($sheet as $row) {
    if ($row['employee_id'] == $_SESSION['user_id'] || (isset($_GET['id']) && $row['id'] == $_GET['id'])) {
        $my_slip = $row;
        break;
    }
}
?>

<?php if(!$my_slip): ?>
<div class="card"><p>Payslip not found for this month.</p></div>
<?php else: ?>
<div class="card" style="max-width: 800px; margin: 0 auto; border: 1px solid #ddd;">
    <div style="text-align: center; border-bottom: 2px solid #ddd; padding-bottom: 20px; margin-bottom: 20px;">
        <h1 style="margin: 0;">AUP Organization</h1>
        <p style="margin: 5px;">PAYSLIP - <?php echo date('F Y', mktime(0,0,0,$month,1)); ?></p>
    </div>
    
    <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
        <div>
            <b>Name:</b> <?php echo $my_slip['full_name']; ?><br>
            <b>ID:</b> <?php echo $my_slip['emp_code']; ?><br>
            <b>Designation:</b> <?php echo $my_slip['designation']; ?>
        </div>
        <div>
            <b>Branch:</b> <?php echo $my_slip['branch_name']; ?><br>
            <b>Date:</b> <?php echo date('d-m-Y'); ?>
        </div>
    </div>

    <table style="width: 100%; border: 1px solid #ddd; margin-bottom: 20px;">
        <tr>
            <th style="background: #f3f4f6; border: 1px solid #ddd; width: 50%;">Earnings</th>
            <th style="background: #f3f4f6; border: 1px solid #ddd; width: 50%;">Deductions</th>
        </tr>
        <tr>
            <td style="vertical-align: top; padding: 0;">
                <table style="width: 100%; border: none;">
                    <?php 
                    $earnings = [
                        'Basic Salary' => $my_slip['basic_salary'],
                        'House Rent' => $my_slip['house_rent'],
                        'Medical' => $my_slip['medical'],
                        'Conveyance' => $my_slip['conveyance'],
                        'Special' => $my_slip['special_allowance'],
                        'Variable' => $my_slip['variable_allowance']
                    ];
                    $total_earn = array_sum($earnings);
                    foreach($earnings as $k=>$v):
                    ?>
                    <tr>
                        <td style="border: none; padding: 5px 10px;"><?php echo $k; ?></td>
                        <td style="border: none; padding: 5px 10px; text-align: right;"><?php echo number_format($v, 2); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </table>
            </td>
            <td style="vertical-align: top; padding: 0;">
                <table style="width: 100%; border: none;">
                    <?php 
                    $deductions = [
                        'Provident Fund' => $my_slip['pf_deduction'],
                        'Other/Loan' => $my_slip['other_deductions']
                    ];
                    $total_deduct = array_sum($deductions);
                    foreach($deductions as $k=>$v):
                    ?>
                    <tr>
                        <td style="border: none; padding: 5px 10px;"><?php echo $k; ?></td>
                        <td style="border: none; padding: 5px 10px; text-align: right;"><?php echo number_format($v, 2); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </table>
            </td>
        </tr>
        <tr style="background: #f9fafb; font-weight: bold;">
            <td style="border: 1px solid #ddd; padding: 10px; text-align: right;">Total Earnings: <?php echo number_format($total_earn, 2); ?></td>
            <td style="border: 1px solid #ddd; padding: 10px; text-align: right;">Total Deductions: <?php echo number_format($total_deduct, 2); ?></td>
        </tr>
    </table>
    
    <div style="text-align: right; font-size: 1.2rem; font-weight: bold; padding: 10px; background: #e5e7eb; border-radius: 4px;">
        NET PAY: <?php echo number_format($my_slip['net_pay'], 2); ?> BDT
    </div>
    
    <div style="margin-top: 50px; text-align: center; color: #6b7280; font-size: 0.8rem;">
        This is a computer generated payslip, no signature required.
    </div>
    
    <div style="margin-top: 20px; text-align: center;">
        <button onclick="window.print()" style="background: #4b5563; color: white; padding: 8px 16px; border: none; border-radius: 4px; cursor: pointer;">Print</button>
    </div>
</div>
<?php endif; ?>
